function M = femX_masma3(vertices)
% function M = femX_masma3(X)
%
%   Spatial element mass matrix for a triangle
%
%   X has dimension 3 x 2 containing the x- & y-coordinates

%   R. Andreev, 2012.10.07

	D_Phi = [vertices(2,:)-vertices(1,:); vertices(3,:)-vertices(1,:)]';

	M = gallery('circul', [2 1 1]);
	M = (1/2) * (M / sum(sum(M)));

	M = abs(det(D_Phi)) * M;
end
