function femX_init(is_first_round)
% function femX_init(is_first_round)
%
%   Initializes the spatial FEM data
%   into global variables of the form femX_*
%    
%   Call with femX_init(true) when called the first time

%   R. Andreev, 2012.10.07
%
%   The femX_* code is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137

	global femX_init_done

	if ((nargin ~= 0) && is_first_round)
		femX_init_done = false;
	end

	if (~isempty(femX_init_done) && femX_init_done)
		return
	end

	femX_init_done = true;

	global femX_coordinates
	global femX_elements3 femX_elements4
	global femX_neumann femX_dirichlet
	global femX_FreeNodes

	load 'femX_coordinates.dat'; femX_coordinates(:,1) = [];
	load 'femX_elements3.dat'; femX_elements3(:,1) = []; 
	load 'femX_elements4.dat'; femX_elements4(:,1) = []; 
	load 'femX_neumann.dat'; femX_neumann(:,1) = []; 
	load 'femX_dirichlet.dat'; femX_dirichlet(:,1) = [];

	femX_FreeNodes = setdiff(1:size(femX_coordinates,1), unique(femX_dirichlet));
end
