function [M, A] = femX_MA
% function [Mx, Ax] = femX_MA
%
%   Spatial mass and stiffness matrices
%
%
%   See Sec 6.1 and Sec 6.2 in
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%       (see README.txt for precise reference)

%   R. Andreev, 2012.10.07
%
%   The femX_* code is essentially due to
%
%       Alberty, J., Carstensen, C., Funken, S.A.
%       Remarks around 50 lines of Matlab
%       Numerical Algorithms, 20 (1999), pp. 117-137

	femX_init

	global femX_coordinates
	global femX_elements3 femX_elements4
	global femX_FreeNodes

	% Assemble M & A

	siz = [9*size(femX_elements3,1)+16*size(femX_elements4,1), 1];
	VM = zeros(siz);
	VA = zeros(siz);
	I = zeros(siz);
	J = zeros(siz);

	idx = 1:9;
	for j = 1:size(femX_elements3,1)
		E = femX_elements3(j,:);
		[dj, di] = meshgrid(E);
		I(idx) = di(:);
		J(idx) = dj(:);
		m = femX_masma3(femX_coordinates(E,:));
		a = femX_stima3(femX_coordinates(E,:));
		VM(idx) = m(:);
		VA(idx) = a(:);
		idx = idx + numel(m);
	end
	
	idx = (idx(1)-1) + (1:16);
	for j = 1:size(femX_elements4,1)
		E = femX_elements4(j,:);
		[dj, di] = meshgrid(E);
		I(idx) = di(:);
		J(idx) = dj(:);
		m = femX_masma4(femX_coordinates(E,:));
		a = femX_stima4(femX_coordinates(E,:));
		VM(idx) = m(:);
		VA(idx) = a(:);
		idx = idx + numel(m);
	end

	M = sparse(I, J, VM);
	M = M(femX_FreeNodes, femX_FreeNodes);

	A = sparse(I, J, VA);
	A = A(femX_FreeNodes, femX_FreeNodes);
end
