function MtF = femT_assemF(TF)
% function MtF = femT_assemF(TF)
%
%   Mass matrix of piecewise constant functions
%   on the 1d mesh TF
%
%
%   See Sec 6.2 in
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%       (see README.txt for precise reference)

%   R. Andreev, 2012.10.22

	K = length(TF)-1;
	MtF = sparse(1:K, 1:K, abs(diff(TF)));
end
