function VolumeForce = data_f(t, x)
% function VolumeForce = data_f(t, x)
%
%   t is a scalar
%   x is a Nx2 matrix of coordinates
%
%   VolumeForce is a Nx1 vector of
%   evaluations of the right hand side f
%   at time t in the coordinates x
%
%   If called with one argument t returns the handle
%
%      @(varargin) data_f(t, varargin{:})
%
%   for the purpose of temporal quadrature
%
%
%   See Sec 2 and Sec 7.2 in
%
%       R. Andreev
%       Space-time discretization of the heat equation
%       Numerical Algorithms, 2014
%       (see README.txt for precise reference)

%   R. Andreev, 2012.10.07

	if (nargin == 1)
		VolumeForce = @(varargin) data_f(t, varargin{:});
		return
	end

	VolumeForce = sin(t) * ones(size(x,1),1);
end
