/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function computeVThreaded, which is a    */
/*        threaded version of the function computeV. It is used in        */
/*        exactly the same way as computeV and has the same output as     */
/*        computeV. This function however is optimized for system with    */
/*        multiple cores and distributes the work load equally among all  */
/*        cores. For this purpose it uses threads.h on the one hand and   */
/*        POSIX threads on the other hand.                                */
/*                                                                        */
/*        Beware: As POSIX threads may not be available, this file is     */
/*        only compiled if the pre-processor flag HILTHREADS is set.      */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '10, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifdef HILTHREADS
#ifndef THREADEDV_H_GUARD
#define THREADEDV_H_GUARD

#include "threads.h"
#include "singleLayerPotential.h"

#define MAX_NUMOF_VWORKERS NUMOF_CORES
#define HILTHR_V_MINROW_PER_WORKER 200

/**************************** computeVThreaded ****************************/
/* INPUT: V is a zeroed array of nE*nE doubles. coordinates is a nCx2     */
/*        matrix and elements is a nEx2 matrix. They are describing the   */
/*        triangulation of the boundary. eta is used to determine the set */
/*        of admissible boundary elements.                                */
/* OUTPUT: This function modifies the matrix by computing and setting its */
/*        entries.                                                        */
/* DESCRIPTION: This function creates a number of                         */
/*        CompWorkerSimple-threads and passes the pointer to the function */
/*        computeVThreadedWorker. Since write-write conflicts cannot      */
/*        occur, the use of genericBoss is not necessary.                 */
/**************************************************************************/
void computeVThreaded(double* V, int nC, int nE, const double* coordinates,
    const double* elements, double eta);

/************************* computeVThreadedWorker *************************/
/* INPUT: A pointer to a data structure of size sizeof(CompWorkerData).   */
/* OUTPUT: Always returns NULL.                                           */
/* DESCRIPTION: For the sub-matrix specified in the given CompWorkerData  */
/*        data this function simply computes the corresponding matrix     */
/*        entries by calling computeVij from singleLayerPotential.h       */
/**************************************************************************/
void* computeVThreadedWorker(void* data);

#endif
#endif

