/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function computeNThreaded, which is a    */
/*        threaded version of the function computeN. It is used in        */
/*        exactly the same way as computeN and has the same output as     */
/*        computeN. This function however is optimized for system with    */
/*        multiple cores and distributes the work load equally among all  */
/*        cores. For this purpose it uses threads.h on the one hand and   */
/*        POSIX threads on the other hand.                                */
/*                                                                        */
/*        Beware: As POSIX threads may not be available, this file is     */
/*        only compiled if the pre-processor flag HILTHREADS is set.      */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '10, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifdef HILTHREADS
#ifndef _THREADEDN_H_GUARD_

void computeNThreaded(double* matrix, const double* coordinates,
    const double* elements, const double* vertices,
    const double* triangles, int nC, int nE, int nV, int nT,
    double eta);

void* computeNThreadedWorker(void* data);

#endif
#endif

