/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function computeKThreaded, which is a    */
/*        threaded version of the function computeK. It is used in        */
/*        exactly the same way as computeK and has the same output as     */
/*        computeK. This function however is optimized for system with    */
/*        multiple cores and distributes the work load equally among all  */
/*        cores. For this purpose it uses threads.h on the one hand and   */
/*        POSIX threads on the other hand.                                */
/*                                                                        */
/*        Beware: As POSIX threads may not be available, this file is     */
/*        only compiled if the pre-processor flag HILTHREADS is set.      */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '10, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifdef HILTHREADS
#ifndef _THREADEDK_H_GUARD_
#define _THREADEDK_H_GUARD_

#include "threads.h"
#include "doubleLayerPotential.h"

/**************************** computeKThreaded ****************************/
/* INPUT: matrix is a zeroed array of nE*nC doubles. coordinates is a     */
/*        nCx2 matrix and elements is a nEx2 matrix. They are describing  */
/*        the triangulation of the boundary. eta is used to determine the */
/*        set of admissible boundary elements.                            */
/* OUTPUT: This function modifies the matrix by computing and setting its */
/*        entries.                                                        */
/* DESCRIPTION: This function calls genericBoss from threads.h and passes */
/*        the pointer to the function computeKThreadedWorker to it.       */
/**************************************************************************/
void computeKThreaded(double* matrix, const double* coordinates,
    const double* elements, int nC, int nE, double eta);

/************************* computeKThreadedWorker *************************/
/* INPUT: A pointer to a data structure of size sizeof(CompWorkerData).   */
/* OUTPUT: Always returns NULL.                                           */
/* DESCRIPTION: This function creates a MatrixFrameQueue and stores the   */
/*        calculated entries there. Another function may shift elements   */
/*        from that queue to assemble the matrix K.                       */
/*                                                                        */
/*        For technical reasons, this function maintains a status-flag    */
/*        within its data structure "data". Shifting elements from the    */
/*        queue is only allowed using the function                        */
/*        MatrixFrameQueueSafeShift as long as the status-flag does not   */
/*        indicate that this function has finished.                       */
/**************************************************************************/
void* computeKThreadedWorker(void* data);

#endif
#endif

