function config = textConfig(varargin)
  if (nargin >= 1)
    config = varargin(1);
  else
    config = defaultConfigure();
  end

  disp('*********************************************************************')
  disp('*** Hello, I''m configure. I will ask you some questions regarding')
  disp('*** the compilation of the toolbox hilberttools. Please keep in mind ')
  disp('*** that the defaults for internal settings have been choosen ')
  disp('*** for a good reason.')
  disp('*********************************************************************')
  disp('')
  
  config.Threading = configureQuestion(...
      'Do you want to enable threads', 'Threading', config.Threading, 'bool');
  if (strcmp(config.Threading, 'yes'))
    config.NumberOfCores = configureQuestion(...
      'How many CPU cores has your machine', 'NumberOfCores', ...
      config.NumberOfCores, 'int');
    config.ThreadingDiagnostics = configureQuestion(...
      'Do you want to enable threading diagnostics', 'ThreadingDiagnostics',...
      config.ThreadingDiagnostics, 'bool');
    if (config.NumberOfCores == 1)
      disp('Usage of threading is discouraged for machines with a single core');
      disp('Please re-run make configure to change these settings.');
    end
  end
  config.Debugging = configureQuestion(...
    'Do you want to enable debug-mode','Debugging',config.Debugging,'bool');
  config.CompFlags = configureQuestion(...
    'If you want to pass any flags to the compiler, simply enter them now', ...
    'CompFlags', config.CompFlags, 'str');
  config.Eps = configureQuestion(...
    'Internal setting', 'Eps', config.Eps, 'num');
  config.Eta = configureQuestion(...
    'Internal setting', 'Eta', config.Eta, 'num');
  config.GaussOrder = configureQuestion(...
    'Internal setting', 'GaussOrder', config.GaussOrder, 'int', ...
    '2', '4', '8', '16', '32');
end