function installWindowsBinaries(config)
  dir = 'source/make/binary/win/';
  if (strcmp(config.Threading, 'yes') && ~strcmp(config.NumberOfCores, '1'))
    numberOfCores = str2num( config.NumberOfCores );
    if numberOfCores == 3
      numberOfCores = 4;
    end
    if numberOfCores >= 5
      numberOfCores = 8;
    end
    dir = [dir 'thr' num2str( numberOfCores ) '/'];
  else
    dir = [dir 'nothr/'];
  end

  if (~exist(dir,'dir'))
    error(['The directory ' dir ' does not exist.']);
  end

  for basename = {'buildK','buildN','buildV','buildW', ...
                  'evaluateK', 'evaluateKadj', 'evaluateN', ...
                  'evaluateV', 'evaluateW'}
    file = [dir basename{:} '.' mexext];
    target = [basename{:} '.' mexext];
    fprintf('%s\n', ['Installing ' basename{:} ' ...']);
    if (~exist(file,'file'))
      error(['The file ' file ' does not exist.']);
    end
    copyfile(file, target);
  end

  disp('Installing pthreadVC2.dll ...');
  if (~exist(['source/make/ext/lib/' mexext '/pthreadVC2.dll'], 'file'))
    error('The file make\ext\lib\pthreadVC2.dll does not exist.');
  end
  copyfile(['source/make/ext/lib/' mexext '/pthreadVC2.dll'], ...
           'pthreadVC2.dll');
end

