function varargout = DialogWinInstall(varargin)
% DIALOGWININSTALL M-file for DialogWinInstall.fig
%      DIALOGWININSTALL, by itself, creates a new DIALOGWININSTALL or raises the existing
%      singleton*.
%
%      H = DIALOGWININSTALL returns the handle to a new DIALOGWININSTALL or the handle to
%      the existing singleton*.
%
%      DIALOGWININSTALL('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DIALOGWININSTALL.M with the given input arguments.
%
%      DIALOGWININSTALL('Property','Value',...) creates a new DIALOGWININSTALL or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DialogWinInstall_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DialogWinInstall_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DialogWinInstall

% Last Modified by GUIDE v2.5 19-Jun-2010 17:26:27
% (C) 2009-2012 HILBERT-Team '09, '10, '12
% license + details:     http://www.asc.tuwien.ac.at/abem/hilbert
% support + bug report:  hilbert@asc.tuwien.ac.at

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DialogWinInstall_OpeningFcn, ...
                   'gui_OutputFcn',  @DialogWinInstall_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before DialogWinInstall is made visible.
function DialogWinInstall_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DialogWinInstall (see VARARGIN)

% Choose default command line output for DialogWinInstall
handles.output = true;
handles.config = defaultConfigure();
handles.config.BinaryInstall = 'yes';
if (~strcmp(handles.config.NumberOfCores,'1'))
    handles.config.Threading = 'yes';
end

% Set default value of popupmenu to number of Cores,
% Note that for #Cores == 3, we choose 4 Threads as default
% If # Cores >= 5 we choose 8 Threads as default
numberOfCores = str2num(handles.config.NumberOfCores);
if numberOfCores == 1
    set(handles.PCores,'Value',1);
elseif numberOfCores == 2
    set(handles.PCores,'Value',2);
elseif numberOfCores == 3
    set(handles.PCores,'Value',3);
elseif numberOfCores == 4
    set(handles.PCores,'Value',3);
elseif numberOfCores >= 5
    set(hanldes.PCores,'Value',4);
else
    set(handles.PCores,'Value',1);
end

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes DialogWinInstall wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = DialogWinInstall_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
varargout{2} = handles.config;
delete(handles.figure1);


% --- Executes on selection change in PCores.
function PCores_Callback(hObject, eventdata, handles)
% hObject    handle to PCores (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns PCores contents as cell array
%        contents{get(hObject,'Value')} returns selected item from PCores
switch (get(hObject,'Value'))
    case 1
        handles.config.Threading = 'no';
        handles.config.NumberOfCores = '1';
    case 2
        handles.config.Threading = 'yes';
        handles.config.NumberOfCores = '2';
    case 3
        handles.config.Threading = 'yes';
        handles.config.NumberOfCores = '4';
    case 4
        handles.config.Threading = 'yes';
        handles.config.NumberOfCores = '8';
    otherwise
        error('Unknown value of the number of cores pulldown menu');
end
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function PCores_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PCores (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in BOK.
function BOK_Callback(hObject, eventdata, handles)
% hObject    handle to BOK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.output = true;
guidata(hObject,handles);
uiresume(handles.figure1);

% --- Executes on button press in BNo.
function BNo_Callback(hObject, eventdata, handles)
% hObject    handle to BNo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.output = false;
guidata(hObject,handles);
uiresume(handles.figure1);
