function varargout = DialogConfig(varargin)
% DIALOGCONFIG M-file for DialogConfig.fig
%      DIALOGCONFIG, by itself, creates a new DIALOGCONFIG or raises the existing
%      singleton*.
%
%      H = DIALOGCONFIG returns the handle to a new DIALOGCONFIG or the handle to
%      the existing singleton*.
%
%      DIALOGCONFIG('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in DIALOGCONFIG.M with the given input arguments.
%
%      DIALOGCONFIG('Property','Value',...) creates a new DIALOGCONFIG or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before DialogConfig_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to DialogConfig_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help DialogConfig

% Last Modified by GUIDE v2.5 01-Jun-2013 12:17:17
% (C) 2009-2012 HILBERT-Team '09, '10, '12
% license + details:     http://www.asc.tuwien.ac.at/abem/hilbert
% support + bug report:  hilbert@asc.tuwien.ac.at

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @DialogConfig_OpeningFcn, ...
                   'gui_OutputFcn',  @DialogConfig_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before DialogConfig is made visible.
function DialogConfig_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to DialogConfig (see VARARGIN)

% Choose default command line output for DialogConfig
if (nargin < 4)
  handles.config = defaultConfigure();
else
  handles.config = varargin{1};
end

fillInFromConfigurationStruct(handles.config);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes DialogConfig wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = DialogConfig_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.config;
delete(handles.figure1);

% --- Executes on button press in CMultiThreading.
function CMultiThreading_Callback(hObject, eventdata, handles)
% hObject    handle to CMultiThreading (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of CMultiThreading


% --- Executes on button press in CDebugging.
function CDebugging_Callback(hObject, eventdata, handles)
% hObject    handle to CDebugging (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of CDebugging

% --- Executes on slider movement.
function SAdmissConst_Callback(hObject, eventdata, handles)
% hObject    handle to SAdmissConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
    val = get(hObject, 'Value');
    TAdmissConst = findobj(gcf, 'Tag', 'TAdmissConst');
    set(TAdmissConst, 'Value', val);
    set(TAdmissConst, 'String', sprintf('%.2f', val));


% --- Executes during object creation, after setting all properties.
function SAdmissConst_CreateFcn(hObject, eventdata, handles)
% hObject    handle to SAdmissConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function TAdmissConst_Callback(hObject, eventdata, handles)
% hObject    handle to TAdmissConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TAdmissConst as text
%        str2double(get(hObject,'String')) returns contents of TAdmissConst as a double


% --- Executes during object creation, after setting all properties.
function TAdmissConst_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TAdmissConst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in DBQuadOrder.
function DBQuadOrder_Callback(hObject, eventdata, handles)
% hObject    handle to DBQuadOrder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns DBQuadOrder contents as cell array
%        contents{get(hObject,'Value')} returns selected item from DBQuadOrder


% --- Executes during object creation, after setting all properties.
function DBQuadOrder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DBQuadOrder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in CThrDiag.
function CThrDiag_Callback(hObject, eventdata, handles)
% hObject    handle to CThrDiag (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of CThrDiag



function TCFlags_Callback(hObject, eventdata, handles)
% hObject    handle to TCFlags (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TCFlags as text
%        str2double(get(hObject,'String')) returns contents of TCFlags as a double


% --- Executes during object creation, after setting all properties.
function TCFlags_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TCFlags (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in save.
function save_Callback(hObject, eventdata, handles)
% hObject    handle to save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.config = getConfigurationStruct();
guidata(hObject, handles);
uiresume(handles.figure1);

function TNumOfCores_Callback(hObject, eventdata, handles)
% hObject    handle to TNumOfCores (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of TNumOfCores as text
%        str2double(get(hObject,'String')) returns contents of TNumOfCores as a double


% --- Executes during object creation, after setting all properties.
function TNumOfCores_CreateFcn(hObject, eventdata, handles)
% hObject    handle to TNumOfCores (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function fillInFromConfigurationStruct(config)
CMultiThreading = findobj(gcf, 'Tag', 'CMultiThreading');
TNumOfCores = findobj(gcf, 'Tag', 'TNumOfCores');
DBQuadOrder = findobj(gcf, 'Tag', 'DBQuadOrder');
SAdmissConst = findobj(gcf, 'Tag', 'SAdmissConst');
TAdmissConst = findobj(gcf, 'Tag', 'TAdmissConst');
CDebugging = findobj(gcf, 'Tag', 'CDebugging');
CThrDiag = findobj(gcf, 'Tag', 'CThrDiag');
TCFlags = findobj(gcf, 'Tag', 'TCFlags');

set(CMultiThreading, 'Value', strcmp(config.Threading, 'yes'));
set(TNumOfCores, 'Value', str2double(config.NumberOfCores));
set(TNumOfCores, 'String', config.NumberOfCores);
set(SAdmissConst, 'Value', str2double(config.Eta));
set(TAdmissConst, 'String', config.Eta);
QuadOrders = get(DBQuadOrder, 'String');
for idx = 1:length(QuadOrders)
  if (strcmp(QuadOrders{idx}, config.GaussOrder))
    break;
  end
end
set(DBQuadOrder, 'Value', idx);
set(CDebugging, 'Value', strcmp(config.Debugging, 'yes'));
set(CThrDiag, 'Value', strcmp(config.ThreadingDiagnostics, 'yes'));
set(TCFlags, 'String', config.CompFlags);

function nConf = getConfigurationStruct()
CMultiThreading = findobj(gcf, 'Tag', 'CMultiThreading');
TNumOfCores = findobj(gcf, 'Tag', 'TNumOfCores');
DBQuadOrder = findobj(gcf, 'Tag', 'DBQuadOrder');
SAdmissConst = findobj(gcf, 'Tag', 'SAdmissConst');
TAdmissConst = findobj(gcf, 'Tag', 'TAdmissConst');
CDebugging = findobj(gcf, 'Tag', 'CDebugging');
CThrDiag = findobj(gcf, 'Tag', 'CThrDiag');
TCFlags = findobj(gcf, 'Tag', 'TCFlags');

nConf = defaultConfigure;
if (get(CMultiThreading, 'Value'))
  nConf.Threading = 'yes';
else
  nConf.Threading = 'no';
end
nConf.NumberOfCores = get(TNumOfCores, 'String');
nConf.Eta = get(TAdmissConst, 'String');
if (get(CDebugging, 'Value'))
  nConf.Debugging = 'yes';
else
  nConf.Debugging = 'no';
end
if (get(CThrDiag, 'Value'))
  nConf.ThreadingDiagnostics = 'yes';
else
  nConf.ThreadingDiagnostics = 'no';
end
contents = get(DBQuadOrder, 'String');
quadorder = contents{get(DBQuadOrder, 'Value')};
nConf.GaussOrder = quadorder;
nConf.CompFlags = get(TCFlags, 'String');
