function [ config ] = defaultConfigure()
  config = struct(...
              'Threading', 'no', ...
              'NumberOfCores', num2str(numberOfCores()), ...
              'ThreadingDiagnostics', 'no', ...
              'Debugging', 'no', ...
              'CompFlags', '', ...
              'Eps', '1e-12', ...
              'Eta', '0.5', ...
              'GaussOrder', '16', ...
              'BinaryInstall', 'no');
end

function N = numberOfCores()
	N = [];
	
	try
	  N = feature('numCores');
	catch
	  try
	    if exist('/proc/cpuinfo', 'file')
	      fid = fopen('/proc/cpuinfo');
	      N = length(strfind(char(fread(fid)'), ['processor' 9]));
	      fclose(fid);
	    elseif ispc
	      N = str2num(getenv('NUMBER_OF_PROCESSORS'));
	    elseif ismac
	      [status, output] = system('sysctl hw.ncpu | awk ''{print $2}''');
	      N = str2num(output);
	    end
	  end
	end
	
	if isempty(N)
	    warning('Was not able to find number of cores. Falling back to 1.');
	    N = 1;
	end
end

