%*** Provides an interactive text-based configuration dialog.
function status = configureText(target)
  try
    answer = configureQuestion(...
    'Do you want me to create a default configuration', 'Answer', 'yes', 'bool');
    if(strcmp(answer,'yes'))
        config = defaultConfigure();
    else
        config = textConfig();
    end
    generateConfigure(config);
    
    disp(' ')
    disp('*********************************************************************')
    answer = configureQuestion(...
        'Configuration has changed! Recompile', 'Answer', 'yes', 'bool');
    if(strcmp(answer,'yes'))
        make clean-build
    else
        disp('Type "make clean-build" to recompile')
        disp(' ')
    end
    
    status = 1;
  catch
    status = 0;
  end
end