function config = Configure() % Do not edit the file source/make/Configure.m, edit
                              % source/make/EmptyConfigure.m instead.
if feature('ShowFigureWindows')
  try % Graphical interface.
    disp('I am trying to run some graphical configuration tools now.');
    disp('If you experience any troubles, please run make configure-text');
    disp('on MATLAB''s command line from within HILBERT''s base directory.');
    if (ispc)
      try
        [tf, config] = DialogWinInstall();
        if (tf)
          generateConfigure(config);
          installWindowsBinaries(config);
          clear Configure;
          return;
        end
      catch
        e = lasterror();
        disp('Could not install binaries due to the following error:');
        disp(e.message);
        disp('I''m going on with the manual installation procedure noew.');
      end
    end
    tf = DialogWannaConfig();
    if (tf)
      config = DialogConfig();
    else
      config = defaultConfigure();
    end
    generateConfigure(config);
    clear Configure;
  catch % An error occured during graphical configuration:
    disp('*********************************************************************')
    disp('An error occured during graphical configuration.')
    disp('I am running a text-based version now.')
    disp('*********************************************************************')
    disp('You can (re-)configure the toolbox individually by typing')
    disp('   make configure-text')
    disp('in the base directory. This will run a text-based configure system')
    disp('*********************************************************************')
    disp('')
    answer = configureQuestion(...
        'Do you want me to create a default configuration', 'Answer', 'yes', 'bool');
    if(strcmp(answer,'yes'))
        config = defaultConfigure();
    else
        config = textConfig();
    end
    generateConfigure(config);
    clear Configure;
  end
else
  disp('*********************************************************************')
  disp('Note: No windows can be displayed in your MATLAB session.')
  disp('      I am running a text-based configuration assistant now.')
  disp('*********************************************************************')
  disp('You can (re-)configure the toolbox individually by typing')
  disp('   make configure-text')
  disp('in the base directory. This will run a text-based configure system')
  disp('*********************************************************************')
  disp('')
  answer = configureQuestion(...
      'Do you want me to create a default configuration', 'Answer', 'yes', 'bool');
  if(strcmp(answer,'yes'))
      config = defaultConfigure();
  else
      config = textConfig();
  end
  generateConfigure(config);
  clear Configure;
end
