/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D. It provides functions to get    */
/*        the gauss points and gauss weights for a certain order.         */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '09, '10, '12                               */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef GAUSS_QUADRATURE_H_GUARD
#define GAUSS_QUADRATURE_H_GUARD

/**************************** getGaussPointsT *****************************/
/* INPUT: int points; only points=7 is permitted at the moment            */
/*        int coordinate: an integer of the set {0,1}                     */
/* OUTPUT: A constant array of doubles containing the gauss points to the */
/*        to the given array size (=points).                              */
/* DESCRIPTION: The function returns quadrature points for x-direction    */
/*        (coordinate=0) or y-direction (coordinate=1).                   */
/**************************************************************************/
const double* getGaussPointsT(int points, int coordinate);

/**************************** getGaussWeightsT ****************************/
/* INPUT: int points; only points=7 is permitted at the moment            */
/* OUTPUT: A constant array of doubles containing the gauss weights to    */
/*        the to the given array size (=points).                          */
/* DESCRIPTION: The function returns quadrature weights for gauss         */
/*        quadrature On the reference triangle conv{(0,0),(1,0),(0,1)}    */
/*        according to the size of the rule (=points)                     */
/**************************************************************************/
const double* getGaussWeightsT(int points);

/***************************** getGaussPoints *****************************/
/* INPUT: int order; an integer of the set {2,4,8,16,32}.                 */
/* OUTPUT: A constant array of doubles containing the gauss points to the */
/*        given order. The array contains exactly "order" elements.       */
/* DESCRIPTION: The function returns quadrature points on the interval    */
/*        [-1,1] for the Gaussian quadrature rule of a given order. It    */
/*        does not create a copy of the gauss points, so modifications of */
/*        the returned array are forbidden.                               */
/**************************************************************************/
const double* getGaussPoints(int order);

/***************************** getGaussPoints *****************************/
/* INPUT: int order; an integer of the set {2,4,8,16,32}.                 */
/* OUTPUT: A constant array of doubles containing the gauss weights to    */
/*        the given order. The array contains exactly "order" elements.   */
/* DESCRIPTION: The function returns quadrature weights for the Gaussian  */
/*        quadrature rule of given order. It does not create a copy of    */
/*        the gauss weights, so modifications of that array are           */
/*        forbidden.                                                      */
/**************************************************************************/
const double* getGaussWeights(int order);

#endif

