/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function evaluateW that evaluates the    */
/*        hypersingular integral operator W on any number of evaluation   */
/*        points on the boundary Gamma.                                   */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '10, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _EVALUATEW_H_GUARD_
#define _EVALUATEW_H_GUARD_

#include "mex.h"

/****************************** mexFunction *******************************/
/* USAGE: evaluateW(coordinates, elements, gh, x, n_x [,eta])             */
/* INPUT: coordinates and elements describe the triangulation of the      */
/*        boundary. gh is a vector that contains the values of g on the   */
/*        points that are given by the coordinates-matrix, i.e. there     */
/*        holds                                                           */
/*                                                                        */
/*        g(coordinates(i,:)) = gh(i).                                    */
/*                                                                        */
/*        x is an (M x 2)-matrix that contains the points, W should be    */
/*        evaluated on. n_x is an (M x 2)-matrix that contains the normal */
/*        vectors of the elements which contain the corresponding         */
/*        evaluation point.                                               */
/* OUTPUT: Returns an M-dimensional vector where M is the number of       */
/*        evaluation points. The i-th entry of that vector is given by    */
/*                                                                        */
/*        Wg(x(i,:)).                                                     */
/*                                                                        */
/* DESCRIPTION: This function is a MEX-wrapper around evaluateW.          */
/**************************************************************************/
void mexFunction(int nlhs, mxArray* plhs[],
                  int nrhs, const mxArray* prhs[]);

/******************************* evaluateK ********************************/
/* INPUT: Wx is an nC-dimensional vector, nC is the number of rows of     */
/*        coordinates, nE is the number of rows of elements, nI is the    */
/*        number of evaluation points, i.e. the number of rows of x.      */
/*        coordinates and elements are matrices describing the            */
/*        triangulation. gh is an nC-dimensional vector such that gh(i)   */
/*        is the function value of g on the i-th coordinate               */
/*        coordinates(i,:). x is an (nI x 2) matrix that contains the     */
/*        evaluation points, where n_x is an (nI x 2) matrix that         */
/*        contains the corresponding normal vectors.                      */
/* OUTPUT: This function modifies the array Wx.                           */
/* DESCRIPTION: evaluateW evaluates the hypersingular integral operator W */
/*        on a number of evaluation points.                               */
/**************************************************************************/
void evaluateW(double* Wx, int nC ,int nE, double* coordinates,
	       double* elements, double* gh, double* x,int nI,
	       double* n_x, double eta);

#endif

