/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function evaluateN that evaluates the    */
/*        Newton potential on any number of evaluation points in R^2.     */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '11                                         */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _EVALUATEN_H_GUARD
#define _EVALUATEN_H_GUARD

#include "newtonPotential.h"

/****************************** mexFunction *******************************/
/* USAGE: s = evaluateN(vertices,volumes,f,x)                             */
/* INPUT: vertices and volumes are matrices describing the triangulation  */
/*        of the domain \Omega f is an element-piecewise constant         */
/*        function x is a (m x 2) array which stores the evaluation       */
/*        points                                                          */
/*                                                                        */
/* OUTPUT: (m x 2) -vector s which contains the evaluations               */
/* DESCRIPTION: This function is a MEX-wrapper around evaluateN           */
/*                                                                        */
/**************************************************************************/
void mexFunction(int nlhs, mxArray** plhs, int nrhs, const mxArray** prhs);

/******************************* evaluateN ********************************/
/* INPUT: s is a vector that stores the return values vertices is a nVert */
/*        x 2 array that stores the coord. of the nodes volumes is a nVol */
/*        x 3 array that stores triangles f is a nVol x 1 vector that     */
/*        stores the values of an elementwise constant function. x is a   */
/*        vector with length nP that stores the evaluation points         */
/* OUTPUT: The function returns the value of the integral -1/(2\pi)       */
/*        \int_\Omega \log(|x-y|)f(y)\,dy                                 */
/* DESCRIPTION: evaluateN evaluates the Newton potential N on a number of */
/*        evaluation points.                                              */
/**************************************************************************/
void evaluateN(double* s, const double* vertices, const double* volumes,
			       const double* f, const double* x, int nc, int ne,
			       	       int np);

#endif
