/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D.                                 */
/*                                                                        */
/*        This file contains the function evaluateK that evaluates the    */
/*        double layer potential operator K tilde on any number of        */
/*        evaluation points within the domain Omega.                      */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '09, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _EVALUATEK_H_GUARD_
#define _EVALUATEK_H_GUARD_

#include "geometry.h"
#include "gaussQuadrature.h"
#include "doubleLayerPotential.h"

/****************************** mexFunction *******************************/
/* USAGE: evaluateK(coordinates, elements, g, z)                          */
/* INPUT: coordinates and elements describe the triangulation of the      */
/*        boundary. g is a vector that contains the values of g_h on the  */
/*        points that are given by the coordinates-matrix, i.e. there     */
/*        holds                                                           */
/*                                                                        */
/*        G(coordinates(i,:)) = g(i).                                     */
/*                                                                        */
/*        z is an (M x 2)-matrix that contains the points, K should be    */
/*        evaluated on.                                                   */
/* OUTPUT: Returns an M-dimensional vector where M is the number of       */
/*        evaluation points. The i-th entry of that vector is given by    */
/*                                                                        */
/*        Ktilde G(z(i,:)).                                               */
/*                                                                        */
/* DESCRIPTION: This function is a MEX-wrapper around evaluateK.          */
/**************************************************************************/
void mexFunction(int nlhs, mxArray* plhs[],
                    int nrhs, const mxArray* prhs[]);

/******************************* evaluateK ********************************/
/* INPUT: Kg_z is an nz-dimensional vector, nc is the number of rows of   */
/*        coordinates, ne is the number of rows of elements, nz is the    */
/*        number of evaluation points, i.e. the number of rows of z.      */
/*        coordinates and elements are matrices describing the            */
/*        triangulation. g is an nc-dimensional vector such that g(i) is  */
/*        the function value of g_h on the i-th coordinate                */
/*        coordinates(i,:). z is an (nz x 2) matrix that contains the     */
/*        evaluation points.                                              */
/* OUTPUT: This function modifies the array Kg_z.                         */
/* DESCRIPTION: evaluateK evaluates the double layer potential operator K */
/*        tilde on a number of evaluation points.                         */
/**************************************************************************/
void evaluateK(double* gx, int nC, int nE, int nX,
                const double* coordinates, const double* elements,
                const double* gh, const double* x, double eta);

#endif
