/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D. It provides some preprocessor   */
/*        constants and functions to handle optional parameters in MEX    */
/*        functions.                                                      */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '09, '10, '12                               */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _CONSTANTS_H_GUARD_
#define _CONSTANTS_H_GUARD_

#include <math.h>

#include "mex.h"

#ifndef EPS
#  define EPS 1e-12
#endif

#ifndef DEFAULT_ETA
#  define DEFAULT_ETA 0.5
#endif

#ifndef GAUSS_ORDER
#  define GAUSS_ORDER 16
#endif

#ifndef M_PI
#  define M_PI 3.14159265358979323846
#endif

#ifndef INFINITY
#   define INFINITY (HUGE_VAL + HUGE_VAL)
#endif

#ifndef NAN
#   define NAN (INFINITY - INFINITY)
#endif

/*************************** extract_scalar_or ****************************/
/* INPUT: const mxArray* rhs - A pointer to an input argument from        */
/*        MATLAB,                                                         */
/*        double default_value - A valid default value for that scalar.   */
/* OUTPUT: If rhs is a scalar, that scalar is returned, otherwise         */
/*        default_value is returned.                                      */
/* DESCRIPTION: Helps MEX functions to handle the optional parameters.    */
/**************************************************************************/
double extract_scalar_or(const mxArray* rhs, double default_value);

#endif

