/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D. It provides functions to handle */
/*        optional parameters in MEX functions.                           */
/*                                                                        */
/*        This file contains only the implementation. For documentation   */
/*        see constnats.h.                                                */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '12                                         */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#include "mex.h"

#include "constants.h"

double extract_scalar_or(const mxArray* rhs, double default_value)
{
  if (mxGetM(rhs) == 1 && mxGetN(rhs) == 1)
  {
    return (double) mxGetScalar(rhs);
  }
  else
  {
    return default_value;
  }
}

