/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D. It provides functions to read   */
/*        the input-parameters, which are relevant to compute the         */
/*        Galerkin-Matrix N corresponding to the Newton potential. Refer  */
/*        either to buildN.m or the file newtonPotential.h for more       */
/*        details.                                                        */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '10, '12                                    */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _BUILDN_H_GUARD_
#define _BUILDN_H_GUARD_

#include "mex.h"

/****************************** mexFunction *******************************/
/* USAGE: N = buildN(coordinates,elements,vertices,triangles [,eta])      */
/* INPUT: coordinates and elements are matrices describing the            */
/*        triangulation of the boundary \Gamma of some domain \Omega. A   */
/*        triangulation on \Omega is given by vertices and triangles.     */
/*                                                                        */
/* OUTPUT: The Galerkin-Matrix N_{kj} of the Newton Potential             */
/* DESCRIPTION: This function is a MEX-wrapper around computeN. For a     */
/*        more detailed documentation see buildN.m                        */
/**************************************************************************/
void mexFunction(int nlhs, mxArray** plhs, int nrhs, const mxArray** prhs);

#endif

