/**************************************************************************/
/* DESCRIPTION: This file is part of the HILBERT program package for the  */
/*        numerical solution of the Laplace equation with mixed boundary  */
/*        conditions by use of BEM in 2D. It provides functions to read   */
/*        the input-parameters, which are relevant to compute the         */
/*        Galerkin-Matrix K corresponding to the double-layer potential.  */
/*        The matrix is given by                                          */
/*                                                                        */
/*        K_{ij} = -1/(2pi)\int_{T_i}\int_{supp phi_j} <y-x,n>/|y-x|^2    */
/*        phi_j(y)ds_y ds_x.                                              */
/*                                                                        */
/**************************************************************************/
/* VERSION: 3.1                                                           */
/**************************************************************************/
/* (C) 2009-2013 HILBERT-Team '09, '10, '12                               */
/* support + bug report:  hilbert@asc.tuwien.ac.at                        */
/**************************************************************************/
#ifndef _BUILDK_H_
#define _BUILDK_H_

/****************************** mexFunction *******************************/
/* USAGE: K = buildK(coordinates,elements [,eta])                         */
/* INPUT: coordinates and elements are matrices describing the            */
/*        triangulation. The optional parameter eta>=0 is used to         */
/*        determine the set of admissible elements. If two elements are   */
/*        admissible, semi analytic computation is performed. Otherwise   */
/*        the corresponding entry of K is computed fully analytically.    */
/*        Pass eta=0 to enforce fully analytic computation of K.          */
/* OUTPUT: The Galerkin-Matrix K_{ij} = < Kphi_j , chi_i >                */
/* DESCRIPTION: This function is a MEX-wrapper around computeK. For a     */
/*        more detailed documentation see buildK.m                        */
/**************************************************************************/
void mexFunction(int nlhs, mxArray** plhs, int nrhs, const mxArray** prhs);

/******************************** computeK ********************************/
/* INPUT: K is a nE x nC matrix. nC and nE are the number of coordinates  */
/*        and elements, respectively. coordinates and elements contain    */
/*        the coordinates and elements of the boundary mesh. eta is the   */
/*        admissibility constant. It is greater or equal than 0.          */
/* OUTPUT: None, this function modifies the matrix K                      */
/* DESCRIPTION: This function generates the panels Ti and Tj. In case of  */
/*        Tj and Ti being segments of the same line the entry K_{ij}      */
/*        vanishes. Otherwise the function computeKij is called for the   */
/*        computation of the corresponding matrix entry.                  */
/**************************************************************************/
void computeK(double* K, const double* coordinates, 
              const double* elements, int nC, int nE, double eta);

#endif

