function myLegend(X1,Y1,Y2,art,txt)
%MYLEGEND   Creates legend for figures.
%   MYLEGEND(X1,Y1,Y2,ART,TXT) creates a legend where
%      (X1,Y1) are the upper left coordinates of the legend,
%      (X1,Y2) are the lower left coordinates of the legend,
%      ART is a cell array which contains the style of the lines, and
%      TXT is a cell array where each element contains a text-string.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

if nargin < 6
  ylog = 1;
else
  ylog = 0;
end

for i=1:length(art)
  if ylog
      y=10^(Y1+(i-1)*(Y2-Y1)/length(art)); 
  else
      y=Y1+(i-1)*(Y2-Y1)/length(art); 
  end
  x1=10^X1;
  x2=10^(X1+.15);
  x3=10^(X1+.075);
  x4=10^(X1+.22);
  plot([x1 x2],[y y],'w')
  tmp = art{i};
  if size(tmp,2) > 3
     plot([x1 x2],[y y],[tmp(1),tmp(3),tmp(4)],'LineWidth',2,'MarkerSize',8);%,'LineWidth',2,'MarkerSize',8
  else
     plot([x1 x2],[y y],[tmp(1),tmp(3)],'LineWidth',2,'MarkerSize',8);%,'LineWidth',2,'MarkerSize',8
  end
  plot(x3,y,tmp,'LineWidth',2,'MarkerSize',8); %,'LineWidth',2,'MarkerSize',8
  text(x4,y,txt{i});%,'FontSize',5
end
