function [alpha,beta,z] = parameters()
%PARAMETERS   Parameters for some Laplace problem.
%   [ALPHA,BETA,Z] = PARAMETERS() allows to modify the singularity for some
%   Laplace problem on an L-shaped domain.
%
%   We treat the Laplace problem
% 
%      -Laplace(u) = 0 in Omega with u = g on Gamma
%
%   For given delta>0, we define a function in polar coordinates
%
%      v_delta(r,theta) = r^delta * cos(delta*theta)
%
%   We prescribe the exact solution of the Laplace equation by
%
%      u(x) = v_{alpha}(x) + v_{beta}(x-z)
%
%   where Z is the uppermost corner of Gamma. Then, v has a generic 
%   singularity at the reentrant corner and an additional singularity at the
%   uppermost corner. Note that the function v_delta can be written in the 
%   complex plane by
%
%      v_delta(a+bi) = Real( (a+bi)^delta )
%
%   which is used for the implementation. 

% (C) 2009-2012 HILBERT-Team '09, '10, '12
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** order of singularities
alpha = 2/3;
beta = 7/8;

%*** point for beta singularity
phi = 3*pi/4;
z = [1 -1] * [cos(phi) -sin(phi);sin(phi) cos(phi)]' /4;

