function [alpha,beta,z] = parameters()
%PARAMETERS   Provides parameters.
%   [ALPHA,BETA,Z] = PARAMETERS() allows to modify the singularity for some
%   Poisson problem.
%
%   We treat the Poisson problem
% 
%      -Laplace(u) = f in Omega with u = g on Gamma (or GammaD)
%
%   We prescribe the exact solution by
%
%      u(x) = |x-z|^(2\beta) + r^{alpha} * cos(alpha*theta)
%
%   where ALPHA = 2/3, BETA = 0.9, and Z = [0.14 0.14].
%
%   The exponents ALPHA, BETA and Z is provided by this function so that
%   the user may easily change the order of the singularity.

% (C) 2010-2012 HILBERT-Team '10, '12
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

alpha = 2/3;
beta = 0.9;
z = 0.14*[1 1];
