function ux = g(x)
%G   Dirichlet data for some Poisson problem.
%   UX = G(X) provides the Dirichlet data for some Poisson problem on an 
%   L-shaped domain.
%
%   We treat the Poisson problem
% 
%      -Laplace(u) = f in Omega with u = g on Gamma (or GammaD)
%
%   We prescribe the exact solution by
%
%                u(x) = |x-z|^(2\beta) + r^{alpha} * cos(alpha*theta)
%
%   where alpha = 2/3, beta = 0.9, and z = [0.14 0.14].
%
%   The evaluation points are given by the (N x 2)-matrix X, and the 
%   (N x 1)-vector Y provides the corresponding function values, i.e.,
%   UX(j) = G(X(j,:)).

% (C) 2010-2012 HILBERT-Team '10, '12
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** exact solution is u(x) = u1(x) + u2(x), where
%***   u1(x) = Real( x1+i*x2)^alpha );
%***   u2(x) = |x-z|^(2*beta) = [ (x1-z1)^2 + (x2-z2)^2 ]^beta

%*** obtain parameters
[alpha,beta,z] = parameters();

%*** evaluate u1(x)
u1x = real((x(:,1)+1i*x(:,2)).^alpha);

%*** evaluate u2(x)
x = x - repmat(z,length(x),1);
u2x = sum(x.^2,2).^beta;

%*** obtain u(x)
ux =  u1x + u2x;
