function [f2s] = generateFather2Son(old2new,old2fine,new2fine)
%GENERATEFATHER2SON   Generates Father2Son relation.
%   [F2S] = GENERATEFATHER2SON(OLD2NEW,OLD2FINE,NEW2FINE) computes the
%   following: if a mesh A is adaptively refined in a mesh B, then 
%   GENERATEFATHER2SON returns the father2son relations between the uniform
%   refinements of A and B.
%
%   Let T_old = {E_1, ..., E_N} be (part of) a boundary mesh, and 
%   T_new = {F_1, ..., F_M} a refinement. The (N x 2) array OLD2NEW provides
%   the father2son relations between T_old and T_new, i.e., if E_i is 
%   refined into F_j and F_k, then OLD2NEW(i,:) = [j k]. If E_i is not 
%   refined, i.e., E_i = F_j, then OLD2NEW(i,:) = [j j].
%
%   Let T_old_fine = {Ef_1, ..., Ef_(2N)} and T_new_fine = 
%   {Ff_1, ..., Ff_(2M)} be uniform refinements of T_old and T_new. Let the
%   (N x 2) array OLD2FINE and the (M x 2) array NEW2FINE be the father2son
%   relations.
%
%   Then the return value is the (2N x 2) array F2S, which is the father2son
%   relation between T_old_fine and T_new_fine.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** determine the number of elements of T_old_fine
f2s = zeros(size(unique(old2fine),1),2);

%*** mark old elements which are not refined, or refined
not_refined = old2new(:,1) == old2new(:,2);
refined = not(not_refined);

%*** transport the father2son arrays for the refined elements
f2s(old2fine(refined,1),:) = new2fine(old2new(refined,1),:);
f2s(old2fine(refined,2),:) = new2fine(old2new(refined,2),:);

%*** transport the father2son arrays for the elements which are not refined
f2s(old2fine(not_refined,1),:) = [ new2fine(old2new(not_refined,1),1) ...
                                   new2fine(old2new(not_refined,1),1)];
f2s(old2fine(not_refined,2),:) = [ new2fine(old2new(not_refined,1),2) ...
                                   new2fine(old2new(not_refined,1),2)];

