function y = phi(x,a,b)
%PHI   Provides the Neumann data for some homogeneous Laplace problem.
%   Y = PHI(X,A,B) evaluates the function
%
%      du/dn(x) 
%   
%   where u(x) = r^{2/3} * cos(2theta/3) in polar coordinates.
%
%   The evaluation points are given by the (N x 2)-matrix X. The (N x 2)-
%   matrices A and B give the nodes of the corresponding boundary elements,
%   i.e., X(j,:) belongs to the line segment Ej = conv{ A(j,:) , B(j,:) }. 
%   This information is used to compute the outer unit normal vector on Ej.
%   The (N x 1)-vector Y provides the corresponding function values, i.e.,
%   Y(j) = du/dn(X(j,:)). 

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** obtain parameter alpha = 2/3
alpha = parameter();

%*** compute normal vector n on [a,b] for x in [a,b]
n = b-a;
n = [n(:,2) -n(:,1)] ./ repmat(sqrt(sum(n.^2,2)),1,2);

%*** compute gradient gradu(x)
[t,r]=cart2pol(x(:,1),x(:,2));
grad(:,1)=alpha*r.^(alpha-1) .* ( cos(t).*cos(alpha*t)+sin(t).*sin(alpha*t) );
grad(:,2)=alpha*r.^(alpha-1) .* ( sin(t).*cos(alpha*t)-cos(t).*sin(alpha*t) );

%*** compute normal derivative d_n u(x) = gradu(x)*n(x)
y = sum(grad.*n,2);

