function alpha = parameter()
%PARAMETER   Provides parameter for the exact solution of the demos.
%   ALPHA = PARAMETER() allows to modify the singularity of the demo-files.
%
%   We treat the Laplace problem
% 
%      -Laplace(u) = 0 in Omega
%
%   We prescribe the exact solution in polar coordinates
%
%      u(x) = r^{2/3} * cos(2theta/3)
%
%   which can also be written in the complex plane by
%
%      u(a+bi) = Real( (a+bi)^(2/3) )
%
%   The exponent ALPHA = 2/3 is provided by this function so that the user 
%   may easily change the order of the singularity.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

alpha = 2/3;

