function y = g(x)
%G   Provides the Dirichlet data for some homogeneous Laplace problem.
%   Y = G(X) evaluates the function 
%
%      u(x) = r^{2/3} * cos(2theta/3)
%
%   in polar coordinates, which can also be written in the complex plane by
%
%      u(a+bi) = Real( (a+bi)^(2/3) )
%
%   The evaluation points are given by the (N x 2)-matrix X, and the 
%   (N x 1)-vector Y provides the corresponding function values, i.e., 
%   Y(j) = G(X(j,:)).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** obtain parameter alpha = 2/3
alpha = parameter();

%*** evaluate Dirichlet data
y = real((x(:,1)+1i*x(:,2)).^alpha);

