function ind = computeEstSlpTau(father2son,V_fine,b_fine,x_coarse)
%COMPUTEESTSLPTAU   (h-h/2)-based two-level estimator tau for Symm's IE.
%   IND = COMPUTEESTSLPTAU(FATHER2SON,V_FINE,B_FINE,X_COARSE) computes the 
%   (h-h/2)-based two-level error estimator tau for the simple-layer 
%   potential.
%
%   Let {E1,...,EN} be a coarse partition of the Dirichlet boundary GammaD.
%   Let phi_coarse be the corresponding Galerkin solution. Let phi_fine be 
%   the Galerkin solution with respect to a uniformly refined mesh. This 
%   function returns  
% 
%      IND(j) = ||| G_Ej (phi_fine - phi_coarse) |||^2
%
%   where G_Ej denotes the Galerkin projection onto span{psi_Ej}. Here, the
%   two-level basis function psi_Ej reads
%
%      psi_Ej = - chi_Ej1 + chi_Ej2
%             
%   where chi_Ej1 and chi_Ej2 denote the characteristic functions of the two
%   sons Ej1 and Ej2 of Ej.
%
%   The matrix FATHER2SON links an element Ej of the coarse mesh to its two
%   sons in the fine mesh. V_FINE is the simple-layer potential matrix with
%   respect to the fine mesh and B_FINE is the corresponding right-hand side
%   vector. X_COARSE is the coefficient vector of phi_coarse with respect to
%   the coarse mesh, whereas phi_fine is not explicitly used in the 
%   implementation.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

nE = size(x_coarse,1);

%*** build index vector son2father to link fine mesh with coarse mesh
son2father = zeros(2*nE,1);
son2father(father2son) = repmat((1:nE)',1,2);

%*** compute energy ||| psi_Ej |||^2 of two-level basis function
energy = 2*( V_fine(father2son(:,1) + 2*nE*(father2son(:,1) - 1)) ...
            - V_fine(father2son(:,1) + 2*nE*(father2son(:,2) - 1)) );

%*** compute residual of x_coarse w.r.t. fine mesh
residual = b_fine - V_fine*x_coarse(son2father);

%*** compute vector of (squared) indicators w.r.t. coarse mesh
ind = ( residual(father2son(:,1)) - residual(father2son(:,2)) ).^2./energy;

