function ind = computeEstSlpMuTilde(coordinates,elements,father2son,x_fine)
%COMPUTEESTSLPMUTILDE   (h-h/2)-based estimator mu-tilde for Symm's IE.
%   IND = COMPUTEESTSLPMUTILDE(COORDINATES,ELEMENTS,FATHER2SON,X_FINE)
%   computes the local contributions of some (h-h/2)-based error estimator 
%   mu-tilde for the simple-layer potential.
%
%   For a coarse partition {E1,...,EN} of the Dirichlet boundary GammaD, the
%   function returns an (N x 1)-vector IND with
%
%      IND(j) = diam(Ej) || (1-Pi_coarse)*phi_fine ||_{L2(Ej)}^2
%
%   Here, Pi_coarse is the L2-projection onto the piecewise constant 
%   functions with respect to the coarse mesh and phi_fine is the Galerkin 
%   solution for the uniformly refined mesh. 
%
%   The matrices COORDINATES and ELEMENTS describe the coarse partition of 
%   GammaD. The matrix FATHER2SON links an element Ej of the coarse mesh to
%   its two sons in the fine mesh. X_FINE is the coefficient vector of the 
%   discrete solution phi_fine with respect to the implicitly given, 
%   uniformly refined mesh.  

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute (squared) local mesh-size
h = sum((coordinates(elements(:,1),:) - coordinates(elements(:,2),:)).^2,2);

%*** compute L2-projection Pi_coarse*phi_fine onto coarse mesh
pi_x_fine = 0.5*( x_fine(father2son(:,1)) + x_fine(father2son(:,2)) );

%*** compute coefficient vector of (1-Pi_coarse)*phi_fine
x_fine(father2son(:,1)) = x_fine(father2son(:,1)) - pi_x_fine;
x_fine(father2son(:,2)) = x_fine(father2son(:,2)) - pi_x_fine;

%*** compute ind(j) = diam(Ej)*|| (1-Pi_coarse)*phi_fine ||_{L2(Ej)}^2
ind = 0.5*h.*( x_fine(father2son(:,1)).^2 + x_fine(father2son(:,2)).^2 );

