function ind = computeEstSlpMu(coordinates,elements,father2son,x_fine,x_coarse)
%COMPUTEESTSLPMU   (h-h/2)-based estimator mu for Symm's IE.
%   IND = COMPUTEESTSLPMU(COORDINATES,ELEMENTS,FATHER2SON,X_FINE,X_COARSE)
%   computes the local contributions of some (h-h/2)-based error estimator 
%   mu for the simple-layer potential.
%
%   For a coarse partition {E1,...,EN} of the Dirichlet boundary GammaD, the
%   function returns an (N x 1)-vector IND with
%
%      IND(j) = diam(Ej) || phi_fine - phi_coarse||_{L2(Ej)}^2
%
%   The functions phi_coarse and phi_fine are the Galerkin solutions for the
%   coarse mesh and its uniform refinement, respectively.
%
%   The matrices COORDINATES and ELEMENTS describe the coarse partition of 
%   GammaD. The matrix FATHER2SON links an element Ej of the coarse mesh to
%   its two sons in the fine mesh. X_COARSE and X_FINE are the coefficient 
%   vectors corresponding to phi_coarse and phi_fine, respectively.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute (squared) local mesh-size
h = sum((coordinates(elements(:,1),:) - coordinates(elements(:,2),:)).^2,2);

%*** compute coefficient vector of (phi_fine - phi_coarse) w.r.t. to fine 
%*** mesh
x_fine(father2son(:,1)) = x_fine(father2son(:,1)) - x_coarse;
x_fine(father2son(:,2)) = x_fine(father2son(:,2)) - x_coarse;

%*** compute ind(j) = diam(Ej)*|| phi_fine - phi_coarse ||_{L2(Ej)}^2
ind = 0.5*h.*( x_fine(father2son(:,1)).^2 + x_fine(father2son(:,2)).^2 );

