function est = computeEstSlpEtaTilde(father2son,V_fine,x_fine)
%COMPUTEESTSLPETATILDE   (h-h/2)-based estimator eta-tilde for Symm's IE.
%   EST = COMPUTEESTSLPETATILDE(FATHER2SON,V_FINE,X_FINE) computes some 
%   (h-h/2)-based error estimator eta-tilde for the simple-layer potential.
%
%   Let {E1,...,EN} be a coarse partition of the Dirichlet boundary GammaD.
%   Let Pi_coarse denote the L2-projection on the piecewise constant 
%   functions w.r.t. the coarse mesh. Let phi_fine be the Galerkin solution
%   with respect to a uniformly refined mesh. This function returns the 
%   energy
% 
%      EST = ||| (1-Pi_coarse)*phi_fine |||^2
%
%   w.r.t. the norm induced by the simple-layer potential.
%
%   The matrix FATHER2SON links an element Ej of the coarse mesh to its two
%   sons in the fine mesh. V_FINE is the simple-layer matrix with respect to
%   the fine mesh. X_FINE is the coefficient vector of phi_fine.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute L2-projection Pi_coarse*phi_fine onto coarse mesh
pi_x_fine = 0.5*( x_fine(father2son(:,1)) + x_fine(father2son(:,2)) );

%*** compute coefficient vector of (1-Pi_coarse)*phi_fine
x_fine(father2son(:,1)) = x_fine(father2son(:,1)) - pi_x_fine;
x_fine(father2son(:,2)) = x_fine(father2son(:,2)) - pi_x_fine;

%*** compute energy ||| (1-Pi_coarse)*phi_fine |||^2
est = x_fine'*(V_fine*x_fine);

