function est = computeEstSlpEta(father2son,V_fine,x_fine,x_coarse)
%COMPUTEESTSLPETA   (h-h/2)-based estimator eta for Symm's IE.
%   EST = COMPUTEESTSLPETA(FATHER2SON,V_FINE,X_FINE,X_COARSE) computes some
%   (h-h/2)-based error estimator eta for the simple-layer potential.
%
%   Let {E1,...,EN} be a coarse partition of the Dirichlet boundary GammaD.
%   Let phi_coarse be the corresponding Galerkin solution. Let phi_fine be 
%   the Galerkin solution with respect to a uniformly refined mesh. This 
%   function returns the energy 
% 
%      EST = ||| phi_fine - phi_coarse |||^2
%
%   w.r.t. the norm induced by the simple-layer potential.
%
%   The matrix FATHER2SON links an element Ej of the coarse mesh to its two
%   sons in the fine mesh. V_FINE is the simple-layer matrix with respect to
%   the fine mesh. X_FINE is the coefficient vector of phi_fine, whereas 
%   X_COARSE is the coefficient vector of phi_coarse.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute coefficient vector of (phi_fine - phi_coarse) w.r.t. to fine 
%*** mesh
x_fine(father2son(:,1)) = x_fine(father2son(:,1)) - x_coarse;
x_fine(father2son(:,2)) = x_fine(father2son(:,2)) - x_coarse;

%*** compute energy ||| phi_fine - phi_coarse |||^2
est = x_fine'*(V_fine*x_fine);

