function ind = computeEstHypTau(elements_fine,elements_coarse,...
                                          father2son,W_fine,b_fine,x_coarse)
%COMPUTEESTHYPTAU   (h-h/2)-based two-level estimator tau for hypsing IE.
%   IND = COMPUTEESTHYPTAU(ELEMENTS_FINE,ELEMENTS_COARSE,...
%                                         FATHER2SON,W_FINE,B_FINE,X_COARSE)
%   computes the (h-h/2)-based two-level error estimator tau for the 
%   hypersingular integral operator.
%
%   Let {E1,...,EN} be a coarse partition of the Neumann boundary GammaN. 
%   Let u_coarse be the corresponding Galerkin solution. Let u_fine be the 
%   Galerkin solution with respect to the uniformly refined mesh. This 
%   function returns an (N x 1)-vector IND with
% 
%      IND(j) = ||| G_Ej (u_fine - u_coarse) |||^2
%
%   where G_Ej denotes the Galerkin projection onto span{psi_Ej}. The two-
%   level basis-function psi_Ej is just the fine-mesh basis function 
%   associated with the midpoint of the coarse-mesh element Ej.
%
%   The coarse partition of GammaN is described by the matrix 
%   ELEMENTS_COARSE. The uniformly refined mesh is then described in terms 
%   of the matrix ELEMENTS_FINE together with the (N x 2)-matrix FATHER2SON
%   which links the index j of a coarse-mesh element Ej to the indices of 
%   its sons. W_FINE is the hypersingular integral operator matrix with 
%   respect to the fine mesh. X_COARSE is the coefficient vector of 
%   u_coarse. B_FINE denotes the right-hand side vector of the discretized
%   hypersingular integral equation. 

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

nC = length(x_coarse);

%*** build index field k = idx(j) such that j-th node of coarse mesh 
%*** coincides with k-th node of fine mesh
idx = zeros(nC,1);
idx(elements_coarse) = [ elements_fine(father2son(:,1),1),...
                         elements_fine(father2son(:,2),2) ];

%*** build index field k = mid(j) such that midpoint of j-th element of 
%*** coarse mesh is k-th node of fine mesh
mid = elements_fine(father2son(:,1),2);

%*** compute coefficient vector of u_coarse w.r.t. fine mesh
x = zeros(length(b_fine),1);
x(mid) = 0.5*sum(x_coarse(elements_coarse),2);
x(idx) = x_coarse;

%*** obtain energies ||| phi_j |||^2 from matrix W_fine where phi_j denotes 
%*** the hatfunction corresponding to j-th node of the uniformly refined 
%*** coarse mesh
energy = diag(W_fine);

%*** compute residual of x_coarse w.r.t. fine mesh
residual = b_fine - W_fine*x;
  
%*** compute vector of (squared) indicators w.r.t. coarse mesh
%*** as described above
ind = residual(mid).^2 ./ energy(mid);

