function ind = computeEstHypMu(elements_fine,elements_coarse,father2son,...
                                                            x_fine,x_coarse)
%COMPUTEESTHYPMU   (h-h/2)-based estimator mu for hypsing IE.
%   IND = COMPUTEESTHYPMU(ELEMENTS_FINE,ELEMENTS_COARSE,FATHER2SON,...
%                                                           X_FINE,X_COARSE)
%   computes the local contributions of some (h-h/2)-based error estimator 
%   mu for the hypersingular integral operator.
%
%   For a coarse partition {E1,...,EN} of the Neumann boundary GammaN, the 
%   function returns an (N x 1)-vector IND with
%
%      IND(j) = diam(Ej) ||(u_fine - u_coarse)'||_{L2(Ej)}^2
%
%   The coarse partition of GammaN is described by the matrix 
%   ELEMENTS_COARSE. The uniformly refined mesh is then described in terms 
%   of the matrix ELEMENTS_FINE together with the (N x 2)-matrix FATHER2SON
%   which links the index j of a coarse-mesh element Ej to the indices of 
%   its sons. X_FINE is the coefficient vector of u_fine, whereas X_COARSE 
%   is the coefficient vector of u_coarse. 

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

nC = length(x_coarse);

%*** build index field k = idx(j) such that j-th node of coarse mesh 
%*** coincides with k-th node of fine mesh
idx = zeros(nC,1);
idx(elements_coarse) = [ elements_fine(father2son(:,1),1), ...
                         elements_fine(father2son(:,2),2) ];

%*** build index field k = mid(j) such that midpoint of j-th element of 
%*** coarse mesh is k-th node of fine mesh
mid = elements_fine(father2son(:,1),2);

%*** compute coefficient vector of (u_fine - u_coarse) w.r.t. fine mesh
x_fine(idx) = x_fine(idx) - x_coarse;
x_fine(mid) = x_fine(mid) - 0.5*sum(x_coarse(elements_coarse),2);

%*** compute h^2*|(u_fine - u_coarse)'|^2 for all fine-mesh elements
%*** where h denotes the diameters of the fine-mesh elements
grad = (x_fine(elements_fine)*[-1;1]).^2;

%*** compute (squared) indicators w.r.t. coarse mesh as described above
ind = 2*( grad(father2son(:,1)) + grad(father2son(:,2)) );

