function est = computeEstHypEta(elements_fine,elements_coarse,father2son,...
                                                     W_fine,x_fine,x_coarse)
%COMPUTEESTHYPETA   (h-h/2)-based estimator eta for hypsing IE.
%   EST = COMPUTEESTHYPETA(ELEMENTS_FINE,ELEMENTS_COARSE,FATHER2SON,...
%                                                    W_FINE,X_FINE,X_COARSE)
%   computes some (h-h/2)-based error estimator eta for the hypersingular 
%   integral operator.
%
%   Let {E1,...,EN} be a coarse partition of the Neumann boundary GammaN. 
%   Let u_coarse be the corresponding Galerkin solution. Let u_fine be the 
%   Galerkin solution with respect to the uniformly refined mesh. This 
%   function returns the energy
% 
%      EST = ||| u_fine - u_coarse |||^2
%
%   w.r.t. the norm induced by the hypersingular integral operator.
%
%   The coarse partition of GammaN is described by the matrix 
%   ELEMENTS_COARSE. The uniformly refined mesh is then described in terms 
%   of the matrix ELEMENTS_FINE together with the (N x 2)-matrix FATHER2SON
%   which links the index j of a coarse-mesh element Ej to the indices of 
%   its sons. W_FINE is the hypersingular integral operator matrix with 
%   respect to the fine mesh. X_FINE is the coefficient vector of u_fine, 
%   whereas X_COARSE is the coefficient vector of u_coarse.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

nC = length(x_coarse);

%*** build index field k = idx(j) such that j-th node of coarse mesh 
%*** coincides with k-th node of fine mesh
idx = zeros(nC,1);
idx(elements_coarse) = [ elements_fine(father2son(:,1),1), ...
                         elements_fine(father2son(:,2),2) ];

%*** build index field k = mid(j) such that midpoint of j-th element of 
%*** coarse mesh is k-th node of fine mesh
mid = elements_fine(father2son(:,1),2);

%*** compute coefficient vector of (u_fine - u_coarse) w.r.t. fine mesh
x_fine(idx) = x_fine(idx) - x_coarse;
x_fine(mid) = x_fine(mid) - 0.5*sum(x_coarse(elements_coarse),2);

%*** compute energy ||| u_fine - u_coarse |||^2
est = x_fine'*(W_fine*x_fine);

