function W = buildW(varargin)
%BUILDW   Galerkin matrix corresponding to hypersingular integral operator.
%   W = BUILDW(COORDINATES, ELEMENTS [,ETA]) assembles the Galerkin matrix 
%   W corresponding to the hypersingular integral operator for S1-ansatz 
%   and S1-test functions.
%
%   For a given partition {E1,...,EN} of a boundary piece Gamma, the 
%   hypersingular integral operator matrix W is an (N x N)-matrix that is 
%   given by 
%
%      Wjk = <W zetak, zetaj>
%
%   where the letter W denotes the hypersingular integral operator 
%   defined by
%
%      Wu = -1/(2pi) \partial n(x)
%                      \int_Gamma \partial n(y) log|x-y| u(y) ds_y.
%
%   In fact, the Galerkin matrix is calculated by use of Nedelec's formula
%   which reads
%
%      < Wu , v > = < Vu' , v' >
%
%   with u', v' the arc-length derivatives of u and v and V the simple-layer
%   potential operator. This turns the computation of W into a relative 
%   simple post-processing step of the calculation of V.
%
%   COORDINATES gives the coordinates for all nodes on Gamma. ELEMENTS 
%   describes the elements on Gamma. If no optional parameter ETA is given,
%   a sane default value is chosen which is defined by DEFAULT_ETA in 
%   geometry.h (0.5). For ETA = 0, all entries of V are computed 
%   analytically. For highly adapted meshes, purely analytical computation 
%   leads to instabilities due to cancellation effects. For ETA > 0, the 
%   outer integration is replaced by Gaussian quadrature in case of
%
%      length(Ei) <= ETA * dist(Ei,Ej)
%
%   In practice, this avoids cancellation effect. Moreover, the order of 
%   integration is always chosen in a way that ensures
%      
%      length(Ei) <= length(Ej).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

error('Please run MAKE in HILBERT root directory!');
