function V = buildV(varargin)
%BUILDV   Galerkin matrix corresponding to simple-layer potential.
%   V = BUILDV(COORDINATES,ELEMENTS [,ETA]) assembles the Galerkin matrix V
%   corresponding to the simple-layer potential operator for P0-ansatz and 
%   P0-test functions.
%
%   For a given partition {E1,...,EN} of a boundary piece Gamma, the 
%   simple-layer matrix V is an (N x N)-matrix with entries
%
%      Vij = -1/(2 pi) int_{Ei} int_{Ej} log|x-y| ds(y) ds(x)
%
%   COORDINATES gives the coordinates for all nodes on Gamma. ELEMENTS 
%   describes the elements on Gamma. If no optional parameter ETA is given,
%   a sane default value is chosen which is defined by DEFAULT_ETA in 
%   geometry.h (0.5). For ETA = 0, all entries of V are computed 
%   analytically. For highly adapted meshes, purely analytical computation 
%   leads to instabilities due to cancellation effects. For ETA > 0, the 
%   outer integration is replaced by Gaussian quadrature in case of
%
%      length(Ei) <= ETA * dist(Ei,Ej)
%
%   In practice, this avoids cancellation effect. Moreover, the order of 
%   integration is always chosen in a way that ensures
%      
%      length(Ei) <= length(Ej).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

error('Please run MAKE in HILBERT root directory!');
