function b = buildSymmVolRHS(coordinates,elements,uDh,vertices,triangles,fh)
%BUILDSYMMVOLRHS   Right-hand side for Symm's IE with volume force.
%   B = BUILDSYMMVOLRHS(COORDINATES,ELEMENTS,UDH,VERTICES,TRIANGLES,FH)
%   assembles the right-hand side for a P0-Galerkin BEM for Symm's IE with 
%   non-homogeneous volume force.
%
%   Symm's integral equation with non-homogeneous f reads
%
%      V*phi = (K+1/2)*uD - N*f
%
%   where uD is the known Dirichlet data for the solution u of 
%   -Laplace(u) = f in Omega with u = uD on Gamma = boundary(Omega).
%
%   Let {E1,...,EN} be a partition of Gamma into affine line segments Ej. 
%   Let {T1,...,TM} be a regular triangulation of Omega into triangles Tj.
%   For the numerical solution of Symm's integral equation by use of a 
%   Galerkin BEM with P0-ansatz and test functions, we replace uD by some 
%   piecewise affine and continuous spline uDh. Moreover, the volume force 
%   f is replaced by some piecewise constant function fh. Then, the 
%   right-hand side vector B is an (N x 1)-vector with entries 
%
%      B(j) = int_{Tj} (K+1/2)*uDh - N*fh ds(x) 
%
%   This is computed analytically by use of the functions buildK and buildN.
%
%   COORDINATES gives the coordinates for all nodes {z1,...,zN} on Gamma. 
%   ELEMENTS describes the elements on Gamma. VERTICES gives the coordinates
%   for all nodes in Omega, and TRIANGLES describes the triangles of the 
%   volume triangulation. The (N x 1)-column vector UDH provides the nodal 
%   values of the discrete Dirichlet data, i.e., uDh(j) = UDH(j). 
%   The (M x 1)-column vector FH provides the elementwise values of fh, 
%   i.e. fh|_{Tj} = FH(j).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute RHS vector for homogeneous volume force
b = buildSymmRHS(coordinates,elements,uDh);

%*** compute N-matrix for P0(Gamma) x P0(Omega)
N = buildN(coordinates,elements,vertices,triangles);

%*** return RHS vector for non-homogeneous volume force
b = b - N*fh;
