function b = buildSymmRHS(coordinates,elements,uDh)
%BUILDSYMMRHS   Right-hand side for Symm's integral equation.
%   B = BUILDSYMMRHS(COORDINATES,ELEMENTS,UDH) assembles the right-hand side
%   for a P0-Galerkin BEM for Symm's integral equation.
%               
%   Symm's integral equation reads
%
%      V*phi = (K+1/2)*uD
%
%   where uD is the known Dirichlet data for the solution u of
%   -Laplace(u) = 0 in Omega with u = uD on Gamma = boundary(Omega).
%
%   Let {E1,...,EN} be a partition of Gamma. For the numerical solution of 
%   Symm's integral equation by use of a Galerkin BEM with P0-ansatz and 
%   test functions, we replace uD by some piecewise affine and continuous 
%   spline uDh. Then, the right-hand side vector B is an (N x 1)-vector with
%   entries
%
%      B(j) = int_{Ej} (K+1/2)*uDh ds(x)
%
%   This is computed analytically by use of the function buildK.
%
%   COORDINATES gives the coordinates for all nodes {z1,...,zn} on Gamma. 
%   ELEMENTS describes the elements on Gamma. The (n x 1)-vector UDH 
%   provides the nodal values of the discrete Dirichlet data, i.e., 
%   uDh(j) = UDH(j).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute DLP-matrix for P0 x S1
K = buildK(coordinates,elements);

%*** compute mass-type matrix for P0 x S1
M = buildM(coordinates,elements);

%*** build right-hand side vector
b = K*uDh + M*uDh*0.5;

