function N = buildN(varargin)
%BUILDN   Assembles Galerkin matrix corresponding to the newton-potential.
%   N = BUILDN(COORDINATES,ELEMENTS,VERTICES,VOLUMES [,ETA]) assembles the 
%   Galerkin matrix N corresponding to the newton-potential operator for 
%   P0(Omega)-ansatz and P0(Gamma)-test functions.
%
%   For a given partition {E1,...,EN} of a boundary piece Gamma and a given
%   partition {T1,...,TM} of a volume triangulation, the newton-potential 
%   matrix N is an (N x M)-matrix with entries
%
%      Nkj = -1/(2 pi) \int_{Ek} \int_{Tj} log|x-y| dx ds(y)
%              
%   COORDINATES gives the coordinates for all nodes on Gamma. ELEMENTS 
%   describes the elements on Gamma. VERTICES gives the coordinates for all
%   nodes in Omega. VOLUMES describes the elements in Omega. If no optional
%   parameter ETA is given, a sane default value is chosen which is defined
%   by DEFAULT_ETA in geometry.h (0.5). For highly adapted meshes, purely 
%   analytic computation leads do instabilities due to cancellation effects.
%   For ETA > 0, the outer integration is replaced by Gaussian quadrature 
%   in case of
%
%      diam(Ek) <= ETA*dist(Ek,Tj).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

error('Please run MAKE in HILBERT root directory!');


