function M = buildM(coordinates,elements)
%BUILDM   Assembles a mass-type matrix M.
%   M = BUILDM(COORDINATES,ELEMENTS) assemples a mass-type matrix M for 
%   P0 x S1.
%
%   The (n x 2)-array COORDINATES and the (m x 2) array ELEMENTS represent 
%   a partition {E1,...,Em} of a boundary piece Gamma with nodes 
%   {z1,...,zn}. The entries of the (m x n)-matrix M for P0 x S1 read 
% 
%      M_ij =  int_{Ei} zeta_j ds,
%
%   where zeta_j is the S1-hat function associated with the node zj. The 
%   output M is a sparse matrix.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

nE = size(elements,1);

%*** build vector of local mesh-size
h = sqrt(sum((coordinates(elements(:,1),:) ...
    -coordinates(elements(:,2),:)).^2,2));

%*** build coordinate format of sparse matrix M
I = reshape(repmat(1:nE,2,1),2*nE,1);
J = reshape(elements',2*nE,1);
A = reshape(repmat(0.5*h,1,2)',2*nE,1);

%*** build sparse matrix from coordinate format
M = sparse(I,J,A);

