function K = buildK(varargin)
%BUILDK   Galerkin matrix corresponding to the double-layer potential.
%   K = BUILDK(COORDINATES,ELEMENTS [,ETA]) assembles the Galerkin matrix K
%   corresponding to the double-layer potential operator for S1-ansatz and 
%   P0-test functions.
%
%   For a given partition {E1,...,EN} of a boundary piece Gamma with 
%   corresponding set of nodes {z1,...,zn}, the double-layer matrix K is an
%   (N x n)-matrix with entries 
%   
%      Kji = int_{Ej} K(zetai) ds
%   
%   where zetaj is the piecewise affine hat function corresponding to the 
%   node zj and where ds denotes integration along the boundary. We stress 
%   that there holds n=N in case of a closed boundary Gamma only, whereas 
%   n>N in general.
%
%   COORDINATES gives the coordinates for all nodes on Gamma. ELEMENTS 
%   describes the elements on Gamma. If no optional parameter ETA is given,
%   a sane default value is chosen which is defined by DEFAULT_ETA in 
%   geometry.h (0.5). For ETA=0, all entries are computed analytically by 
%   use of appropriate anti-derivatives. For highly adapted meshes, this 
%   leads to instabilities due to cancellation effects. Note that the
%   computation of the matrix entries leads to double integrals of the type
%
%      int_{Ej} int_{Ek} zetai(y) (x-y).ny / |x-y|^2 ds(y) ds(x)
%
%   with ny the unit normal vector on Ek. For ETA > 0, the outer 
%   integration is replaced by Gaussian quadrature in case of
%
%      length(Ej) <= ETA * dist(Ej,Ek)
%
%   In practice, this avoids cancellation effects. Moreover, the order of 
%   integration is always chosen in a way that ensures
%      
%      length(Ej) <= length(Ek).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

error('Please run MAKE in HILBERT root directory!');
