function [b,lambdah] = buildHypsingVolRHS(coordinates,elements, ...
                                                phih,vertices,triangles,fh)
%BUILDHYPSINGVOLRHS   Right hand-side for hypsing IE with volume force.
%   [B [,LAMBDAH]] = BUILDHYPSINGVOLRHS(COORDINATES,ELEMENTS, ...
%                                               PHIH,VERTICES,TRIANGLES,FH)
%   assembles the right hand-side for a S1-Galerkin BEM for the hyper-
%   singular IE with non-homogeneous volume force. In addition, it returns
%   some P0-Galerkin BEM solution lambdah used for the approximation of the
%   normal derivative of the Newton potential.
%
%   The hypersingular IE with non-homogeneous f reads
%
%      W*uD = (1/2 - K')*phi - N_1*f
%
%   where phi = du/dn on Gamma = boundary(Omega) is the known Neumann data 
%   for the solution u of 
%   
%      -Laplace(u) = f   in Omega
%            du/dn = phi on Gamma
%
%   The normal derivative of the Newton Potential, N_1*f, can be described 
%   equivalently by
%              
%      N_1 = (-1/2 + K')*V^(-1)*N
%
%   where N is the trace of the Newton potential on Gamma. This means that 
%   we first solve some indirect boundary integral equation
%
%      V*\lambda = N*f
%
%   In a second step, this is used to solve the hypersingular IE
%
%      W*uD = (1/2 - K')*(phi + lambda).
%
%   Let {E1,...,EN} be a partition of Gamma. We replace phi by some 
%   Ej-piecewise constant function phih. Moreover, with {T1,...,TM} being a
%   triangulation of Omega, we replace f by some Tk-piecewise constant 
%   function fh. We then compute the right-hand side vector  
%
%      b(i) = < (1/2-K')*(phih+lambdah) , zetai >
%
%   where zetai is the hat-function corresponding to the node zi and where 
%   lambdah is a P0-BEM approximation of lambda.
%
%   COORDINATES gives the coordinates for all nodes on Gamma. ELEMENTS 
%   describes the elements {E1,...,EN} on Gamma. VERTICES gives the 
%   coordinates for all vertices in Omega, and TRIANGLES describes the 
%   triangles {T1,...,TM} of the volume triangulation.
%   The (N x 1)-column vector PHIH and the (M x 1)-column vector FH provide
%   the elementwise values of phih and fh. The (N x 1)-column vector B 
%   provides the right-hand side for an S1-Galerkin BEM to approximate uD 
%   by uDh. The optional (N x 1)-column vector LAMBDAH contains the 
%   elementwise values of the P0-Galerkin BEM solution to approximate 
%   lambda.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute N-matrix for P0(Gamma) x P0(Omega)
N = buildN(coordinates,elements,vertices,triangles);

%*** compute N*fh and free unnecessary memory
Nfh = N*fh;
clear N;

%*** compute SLP matrix
V = buildV(coordinates,elements);

%*** solve Symm's IE for the computation of N_1*f
lambdah = V\Nfh;
clear V;

%*** compute DLP matrix for P0 x S1
K = buildK(coordinates,elements);

%*** compute mass-type matrix for P0 x S1
M = buildM(coordinates,elements);

%*** build right-hand side vector
phih = phih + lambdah;
b = (phih'*M*0.5 - phih'*K)';
