function b = buildHypsingRHS(coordinates,elements,phih)
%BUILDHYPSINGRHS   Right-hand side for the hypersingular IE.
%   B = BUILDHYPSINGRHS(COORDINATES,ELEMENTS,PHIH) assembles the right-hand
%   side for the hypersingular IE with S1-elements.
%
%   The hypersingular integral equation reads
%
%      W*u = (1/2-K')*phi
%
%   where phi are the known Neumann data for the solution u of
%   -Laplace(u) = 0 in Omega with du/dn = phi on Gamma.
%
%   Let {E1,...,EN} be a partition of Gamma. We replace phi by some
%   piecewise constant function phih. We then compute the right-hand side 
%   vector  
%
%      b(i) = < (1/2-K')*phih , zetai >
%
%   where zetai is the hat-function corresponding to the node zi.
%
%   COORDINATES gives the coordinates for all nodes. ELEMENTS describes the
%   boundary elements. The (N x 1)-vector PHIH provides the elementwise 
%   values of the discrete Neumann data phih, i.e. phih|_{Ej} = PHIH(j).

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1

%*** compute DLP-matrix for P0 x S1
K = buildK(coordinates,elements);

%*** compute mass-type matrix for P0 x S1
M = buildM(coordinates,elements);

%*** build right-hand side vector
b =  (phih'*M*0.5 - phih'*K)';