% HILBERT program package
% Version 3.1 (2013) 31-May-2013
%
% Integral operators and other matrices
%   buildHypsingStabilization - Stabilization matrix for the hypersingular IE.
%   buildK                    - Galerkin matrix corresponding to the double-layer potential.
%   buildM                    - Assembles a mass-type matrix M.
%   buildN                    - Assembles Galerkin matrix corresponding to the newton-potential.
%   buildV                    - Galerkin matrix corresponding to simple-layer potential.
%   buildW                    - Galerkin matrix corresponding to hypersingular integral operator.
%
% Point evalution of integral operators
%   evaluateK                 - Pointwise evaluation of the double-layer potential.
%   evaluateKadj              - Pointwise evaluation of adjoint double-layer potential.
%   evaluateN                 - Pointwise evaluation of the Newton potential.
%   evaluateN1                - Pointwise evaluation of the Newton potential N1.
%   evaluateV                 - Pointwise evaluation of the simple-layer potential.
%   evaluateW                 - Pointwise evaluation of the hypersingular integral operator.
%
% Error estimators
%   computeEstHypEta          - (h-h/2)-based estimator eta for hypsing IE.
%   computeEstHypEtaTilde     - (h-h/2)-based estimator eta-tilde for hypsing IE.
%   computeEstHypMu           - (h-h/2)-based estimator mu for hypsing IE.
%   computeEstHypMuTilde      - (h-h/2)-based estimator mu-tilde for hypsing IE.
%   computeEstHypResidual     - Weighted-residual estimator for hypsing IE.
%   computeEstHypTau          - (h-h/2)-based two-level estimator tau for hypsing IE.
%   computeEstMixResidual     - Weighted-residual estimator for mixed problem.
%   computeEstMixTau          - (h-h/2)-based two-level estimator for mixed problem.
%   computeEstSlpEta          - (h-h/2)-based estimator eta for Symm's IE.
%   computeEstSlpEtaTilde     - (h-h/2)-based estimator eta-tilde for Symm's IE.
%   computeEstSlpMu           - (h-h/2)-based estimator mu for Symm's IE.
%   computeEstSlpMuTilde      - (h-h/2)-based estimator mu-tilde for Symm's IE.
%   computeEstSlpResidual     - Weighted-residual estimator for Symm's IE.
%   computeEstSlpTau          - (h-h/2)-based two-level estimator tau for Symm's IE.
%
% Error of discrete approximations
%   computeErrDirichlet       - Error between a function and S1-approximation.
%   computeErrNeumann         - Error between a function and P0-approximation.
%
% Discrete data and oscillations
%   computeOscDirichlet       - Computes oscillations and discrete Dirichlet data.
%   computeOscDirichletL2     - Computes oscillations and discrete Dirichlet data.
%   computeOscMixed           - Computes oscillations and discrete data.
%   computeOscNeumann         - Computes oscillations and discrete Neumann data.
%   computeOscVolume          - Computes oscillations and discrete volume data.
%
% Mesh manipulation and marking
%   buildSortedMesh           - Provides a numbering of the nodes.
%   generateFather2Son        - Generates Father2Son relation.
%   markElements              - Marks elements for refinement.
%   refineBoundaryMesh        - Refines a given boundary mesh.
%   refineMesh                - Refines a given volume mesh.
%
% Build right-hand side
%   buildHypsingRHS           - Right-hand side for the hypersingular IE.
%   buildHypsingVolRHS        - Right hand-side for hypsing IE with volume force.
%   buildMixedRHS             - Right hand-side for a mixed problem.
%   buildMixedVolRHS          - Right-hand side for mixed problem with volume force.
%   buildSymmRHS              - Right-hand side for Symm's integral equation.
%   buildSymmVolRHS           - Right-hand side for Symm's IE with volume force.
%
% Visualization tools
%   plotArclengthP0           - Plots P0-function.
%   plotArclengthS1           - Plots S1-function.
%
% Build system
%   make                      - Builds HILBERT's operators.

% (C) 2009-2013 HILBERT-Team '09, '10, '12, '13
% support + bug report:  hilbert@asc.tuwien.ac.at
%
% Version: 3.1
