#include "Util.h"

/************************************************************************\
*  Authors: 	Luisa D'Amore - University of Naples, Federico II	*
*		Rosanna Campagna - University of Naples, Federico II	*
*		Valeria Mele - University of Naples, Federico II	*
*		Almerico Murli - SPACI - NAPLES                   	*
* 		Mariarosaria Rizzardi - University of Naples Parthenope	*
\************************************************************************/


/*ReLaTIve TESTING Auxiliary routines*/
	

/*Laguerre Polynomial*/
double Laguerre(int K, double x){
	int k=0;
	double temp1=0, temp2=0, LK=0;
	double L0=1;
	double L1=1-x;
	for(k=2;k<=K;k++){
		temp1=(-x+2*((double) k)-1)/(double)(k);
		temp2=(((double) k)-1)/(double)(k); 
		LK=temp1*L1-temp2*L0;
		L0=L1;
		L1=LK;
	}	
	return LK;
}

/*Hermite Polynomial*/
double Hermite(int K, double x){
	int k=0;
	double temp1=0, temp2=0, HK=0;
	double H0=1;
	double H1=2*x;
	for(k=2;k<=K;k++){
		temp1=2*x*H1;
		temp2=2*(k-1)*H0; 
		HK=temp1-temp2;
		H0=H1;
		H1=HK;
	}	
	return HK;
}

/*Routine to write the Error Estimate Diagnostic in output files*/
void print_flags_file(FILE *fp){

	fprintf(fp,"\n******************************************************************************************************\n");
	fprintf(fp,"\n                 	                       ERROR ESTIMATE DIAGNOSTIC\n");
	fprintf(fp,"\na. flag = 0  (estabserr and estrelerr) < TOL\n");
	fprintf(fp,"             The computed  value of the inverse Laplace function agrees with the true one within\n");
	fprintf(fp,"             log(TOL) significant and decimal digits. \n");
	fprintf(fp,"\nb. flag = 1  estabserr=MIN(estabserr) and estrelerr=MIN(estrelerr) where the minimum is looked\n");
	fprintf(fp,"             for among the N_max algorithm's steps.\n");
	fprintf(fp,"             Within N_max terms of the Laguerre series expansion, the algorithm cannot satisfy\n");
	fprintf(fp,"             the user's required accuracy.\n");
	fprintf(fp,"             Instead, the algorithm provides  numerical result within  the maximum attainable\n");
	fprintf(fp,"             accuracy. The maximum attainable accuracy is computed as the minimum value of estabserr\n");
	fprintf(fp,"             (and estrelerr) and Nopt is the  number of terms  at which such minimum is reached.\n");
	fprintf(fp,"             This occurs if  the series seems to converge too slowly or to diverge.\n");
	fprintf(fp,"             User is invited  to verify  if the test function satisfies algorithm's requirements: \n");
	fprintf(fp,"			 overall, user should verify the convergence abscissa and the singularity at infinity given as input.\n");
	fprintf(fp,"\nc. flag = 2  estabserr  < TOL.\n");
	fprintf(fp,"             The absolute error estimate is smaller than the user's required accuracy TOL. \n");
	fprintf(fp,"             This mainly occurs if the inverse function rapidly decreases towards zero.\n");
	fprintf(fp,"\nd. flag = 3  estrelerr < TOL.\n");
	fprintf(fp,"             The relative error estimate is smaller than the user's required accuracy TOL.\n");
	fprintf(fp,"             This mainly occurs if the inverse function rapidly increases.\n");
	fprintf(fp,"\n*******************************************************************************************************\n");
	fprintf(fp,"\n\n\n");
	return;
}


/*Routine to write the role of Ncalc and Nopt in output files*/
void print_N_file(FILE *fp, int nmax){

	fprintf(fp,"\n******************************************************************************************************\n");
	fprintf(fp,"\n                 	                       Relation between Nopt and Ncalc\n");
	fprintf(fp,"\nNcalc is the maximum number of terms of the Laguerre series expansion calculated by the algorithm.\n");
	fprintf(fp,"\nNopt is the number of terms of the Laguerre series expansion that gives the numerical result within\n");
	fprintf(fp,"\n		the maximum attainable accuracy, less or equal to N_max=%d\n",nmax);
	fprintf(fp,"\n\n");
	fprintf(fp,"\na. Nopt=Ncalc<N_max=%d\n",nmax);
	fprintf(fp,"             The computed  value of the inverse Laplace function agrees with the true one within\n");
	fprintf(fp,"             log(TOL) significant and decimal digits. \n");
	fprintf(fp,"             This value is obtained calculating Nopt terms of the Laguerre series expansion.\n");
	fprintf(fp,"             It should be flag = 0 \n");
	fprintf(fp,"\nb. Nopt<Ncalc=N_max=%d\n",nmax);
	fprintf(fp,"             Within N_max terms of the Laguerre series expansion, the algorithm cannot satisfy\n");
	fprintf(fp,"             the user's required accuracy.\n");
	fprintf(fp,"             Instead, the algorithm provides  numerical result within  the maximum attainable\n");
	fprintf(fp,"             accuracy, and Nopt is the  number of terms  at which such maximum is reached.\n");
	fprintf(fp,"             This occurs if the series seems to diverge.\n");
	fprintf(fp,"\nc. Nopt=Ncalc=N_max=%d\n",nmax);
	fprintf(fp,"             This occurs if:\n");
	fprintf(fp,"             - Within N_max terms of the Laguerre series expansion, the algorithm cannot satisfy\n");
	fprintf(fp,"               the user's required accuracy, but the series seems to converge, even if very slowly: \n");
	fprintf(fp,"               the algorithm provides numerical result within the maximum attainable accuracy, reached \n");
	fprintf(fp,"               within N_max terms of the Laguerre series expansion.\n");
	fprintf(fp,"             or if:\n");
	fprintf(fp,"             - Within N_max terms of the Laguerre series expansion, the algorithm cannot satisfy\n");
	fprintf(fp,"               the user's required accuracy and the series seems to diverge.\n");
	fprintf(fp,"               Instead, the algorithm provides  numerical result within  the maximum attainable\n");
	fprintf(fp,"               accuracy, and Nopt is the  number of terms  at which such maximum is reached.\n");
	fprintf(fp,"               that accidentally corresponds with N_max\n");
	fprintf(fp,"             or if:\n");
	fprintf(fp,"             - The algorithm can satisfy the user's required accuracy, within N_max terms of the Laguerre \n");
	fprintf(fp,"               series expansion, so the series seems to converge, even if quite slowly: \n");
	fprintf(fp,"               the algorithm provides numerical result within the maximum attainable accuracy, reached \n");
	fprintf(fp,"               within N_max terms of the Laguerre series expansion.\n");
	fprintf(fp,"               It should be flag = 0 \n");
	fprintf(fp,"\n*******************************************************************************************************\n");
	fprintf(fp,"\n\n\n");
	return;
}



